#!/bin/csh

#
# Basic 2D Phase-Sensitive Processing:
#   Cosine-Bells are used in both dimensions.
#   Use of "ZF -auto" doubles size, then rounds to power of 2.
#   Use of "FT -auto" chooses correct Transform mode.
#   Imaginaries are deleted with "-di" in each dimension.
#   Phase corrections should be inserted by hand.

nmrPipe -in test.fid \
#| nmrPipe  -fn POLY -time                             \
| nmrPipe  -fn GM -g1 20 -g2 25 -c 0.5	\
#| nmrPipe  -fn SP -off 0.35 -end 1.00 -pow 2 -c 0.5    \
| nmrPipe  -fn ZF -auto                               \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 230 -p1 0 -di -verb       \
#| nmrPipe  -fn CS -ls -3.8ppm -sw	\
| nmrPipe  -fn EXT -x1 2.7ppm -xn -1ppm -sw         \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn GM -g1 20 -g2 25 -c 0.5	\
#| nmrPipe  -fn LP -fb                            \
#| nmrPipe  -fn SP -off 0.35 -end 1.00 -pow 2 -c 0.5    \
#| nmrPipe  -fn LP -pred 25                            \
| nmrPipe  -fn ZF -auto                               \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 -90 -p1 180 -di -verb           \
| nmrPipe  -fn POLY -auto                             \
| nmrPipe  -fn TP                                     \
#| nmrPipe  -fn POLY -auto                             \
#| nmrPipe  -fn CS -ls 1ppm -sw	\
-ov -out test.ft2
#| pipe2xyz -nv -ov -out  hsqc.nv                     

