#!/bin/csh
#
# nmrpipe script for processing 2D HSQC
#
#
set CONVERSION = y
set PROCESSING = y
set PIPE2XEASY = y
#
# 1. data conversion
#
if ($CONVERSION == 'y') then
bruk2pipe -verb -in ./ser \
  -bad 0.0 -ext -aswap -AMX -decim 1792 -dspfvs 20 -grpdly 67.9841766357422  \
  -xN              2048  -yN               400  \
  -xT              1024  -yT               200  \
  -xMODE            DQD  -yMODE    States-TPPI  \
  -xSW        11160.714  -ySW         2269.632  \
  -xOBS         799.864  -yOBS          81.059  \
  -xCAR           4.773  -yCAR         117.084  \
  -xLAB              HN  -yLAB             15N  \
  -ndim               2  -aq2D         Complex  \
| nmrPipe -fn MULT -c 3.90625e+00 \
      -ov -out ./DomainIV_hsqc.fid -verb
endif
# 
# 2. processing
#
if ($PROCESSING == 'y') then
   nmrPipe -in ./DomainIV_hsqc.fid                 \
   |   nmrPipe -fn POLY -time			\
   |   nmrPipe -fn SP -off 0.4 -end 0.98 -c 0.5\
   |   nmrPipe -fn ZF -auto                     \
   |   nmrPipe -fn FT -auto                     \
   |   nmrPipe -fn PS -p0 -76.0 -p1 0.0 -di       \
   |   nmrPipe -fn EXT -x1 10ppm -xn 6ppm -round 2 -sw \
   |   nmrPipe -fn TP                           \
   |   nmrPipe -fn LP -fb -pred 56		\
   |   nmrPipe -fn SP -off 0.4 -end 0.98 -c 1.0 \
   |   nmrPipe -fn ZF -auto                     \
   |   nmrPipe -fn FT -auto -verb               \
   |   nmrPipe -fn PS -p0 -90 -p1 180.0 -di         \
   |   nmrPipe -fn TP                           \
   |   nmrPipe -ov -out ./DomainIV_hsqc.ft2 
endif

peakHN.tcl -in ./DomainIV_hsqc.ft2 -out hn.tab -hi 1.5e7