;BB_2D_BTROSY
;avance-version (12/01/11)
;Best-TROSY
;
;(E. Lescop, P. Schanda & B. Brutscher,
;   J. Magn. Reson.  187 163-169 (2007))
;(T. Schulte-Herbrueggen & O.W. Sorensen, J. Magn. Reson. 144, 
;   123 - 128 (2000))
;
;$CLASS=IBS
;$DIM=2D
;$TYPE=
;$SUBTYPE=
;$COMMENT=


prosol relations=<IBS>


#include <Avance.incl>
#include <Grad.incl>
#include <Delay.incl>



define list<gradient> EA3 = { 1.0000 0.8750 }
define list<gradient> EA5 = { 0.6667 1.0000 }
define list<gradient> EA7 = { 1.0000 0.6595 }

/******************************************************/
/*  Predefined shapes for 1H pulses       *************/
/*  cnst1: center of excitation band     **************/
/*  cnst2: excitation band width         **************/
/******************************************************/
 
/*  PC9 (p41, sp25)   */
"p41=7.2/(cnst2*bf1/1000000)" /*  PC9  pulse length  */
"spw25=plw1*(pow((p1*1.01/p41)/0.125,2))" /* PC9  power level  */
"spoff25=bf1*(cnst1/1000000)-o1"  /*  PC9  offset */
"spoal25=0.5"

/*  REBURP (p42, sp26)   */

"p42=4.875/(cnst2*bf1/1000000)" /* REBURP pulse length  */
"spw26=plw1*(pow((p1*1.97/p42)/0.0798,2))"   /* REBURP power level  */
"spoff26=bf1*(cnst1/1000000)-o1" /* REBURP offset */
"spoal26=0.5"

/*  EBURP & EBURP_TR  (p43, sp28, sp29)   */

"p43=4.6/(cnst2*bf1/1000000)" /*  EBURP pulse length   */
"spw28=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP power level  */
"spw29=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP power level  */
"spoff28=bf1*(cnst1/1000000)-o1" /*  EBURP offset */
"spoal28=0"
"spoff29=bf1*(cnst1/1000000)-o1" /*  EBURP_REV offset */
"spoal29=1.0"

"p16=1000u"
"p17=300u"

/*******************************************************************/
/*   13C Adiabatic pulse                                                        */
/*******************************************************************/

"p8=500"
#   ifdef LABEL_CN
"if ( bf2 < 165 ) {spw13=plw2*(pow((p3/25.5832),2)); } else{spw13=plw2*(pow((p3/22.1557),2));} "
#   else
#   endif /*LABEL_CN*/

/*******************************************************************/
/*   calculation of shaped 15N pulse parameters                    */
/*******************************************************************/
"p50 =500u"    /* BIP pulse length  */
"spoff50=0.0" /*  BIP offset */
"spw50=plw3*(pow((p21*8/p50),2))"   /* BIP power level  */

"p51=4.875/(40*bf3/1000000)" /* REBURP pulse length  */
"spw51=plw3*(pow((p21*1.97/p51)/0.0798,2))"   /* REBURP power level  */
"spoff51=0.0"                /* REBURP offset */
"spoal51=0.5"


/*******************************************************************/
/*   DELAYS                                                        */
/*******************************************************************/

"d11=30m"

"d25=2.6m"
"d26=2.7m"
"d27=2.5m"  /* set slightly shorter than d26 for relaxation compensation  */

"DELTA1=d25-p41*0.5-p42*0.5"
"DELTA2=d27-p17-d16-p42*0.5-p43*0.5"
"DELTA3=d26-p17-d16-p42*0.5"

#   ifdef LABEL_CN
"DELTA=d0*2+p8+p21*4/3.1416"
#   else
"DELTA=d0*2+p21*4/3.1416"
#   endif /*LABEL_CN*/


/*******************************************************************/
/*   time incremennts in 15N dimension                             */
/*******************************************************************/
"d0=3u"
"in0=inf1/2"



"acqt0=0"
baseopt_echo


1 d11 ze
2 d11
3 5u pl1:f1 pl2:f2 pl3:f3
  (p50:sp50 ph8):f3
  d1
  50u UNBLKGRAD
/**************************************/
/*   H-N transfer                     */
/**************************************/
  (p41:sp25 ph3)    /*  PC9  */
 
  DELTA1
  (center (p42:sp26 ph2) (p50:sp50 ph1):f3 )

  DELTA1  pl3:f3
  (p41:sp25 ph11):f1   /*  PC9  */

  p16:gp2
  d16
/**************************************/
/*   15N labeling                     */
/**************************************/
  (p21 ph5):f3
  d0

#   ifdef LABEL_CN
  (p8:sp13 ph1):f2
#   else
#   endif /*LABEL_CN*/

  d0
  (p50:sp50 ph1):f3
  DELTA

  p16:gp3*EA3
  d16
;  30u ;  1st order phase compensation

/**************************************/
/*   TROSY-type H-N back transfer     */
/**************************************/
  (p43:sp29 ph6)   /* EBURP_REV */
  p17:gp4
  d16
  DELTA2
  (center (p42:sp26 ph2) (p50:sp50 ph2):f3 )
  DELTA2  pl3:f3
  p17:gp4
  d16
  (p43:sp28 ph1)    /* EBURP  */
/**************************************/

  p16:gp5*EA5
  d16
;  30u ;  1st order phase compensation

/**************************************/
  (p21 ph1):f3
  p17:gp6
  d16
  DELTA3
  (center (p42:sp26 ph2) (p51:sp51 ph2):f3 )
  DELTA3 pl3:f3
  p17:gp6
  d16 
  (p21 ph7):f3
/**************************************/

  p16:gp7*EA7
  d16  BLKGRAD
/**************************************/
/*   Signal detection & looping       */
/**************************************/
  go=2 ph31
  d11 mc #0 to 2 
     F1EA(calgrad(EA3) & calgrad(EA5) & calgrad(EA7) & calph(ph6, +180) & calph(ph7, +180), caldel(d0, +in0) & calph(ph5, +180) & calph(ph31, +180))
exit


ph1=0
ph11=1
ph2=3 
ph3=2
ph4=3
ph5=0 2
ph6=1
ph7=1
ph8=0
ph31=0 2


;pl0 : 0W
;pl1 : f1 channel - power level for pulse (default)
;pl3 : f3 channel - power level for pulse (default)
;sp13: f2 channel - shaped pulse 180 degree (Ca and C=O, adiabatic)
;sp26: Reburp.1000
;sp25: Pc9_4_90.1000
;sp28: Eburp2.1000
;sp29: Eburp2tr.1000
;p16:  gradient pulse                         [1 msec]
;p29:  gradient pulse
;p21: f3 channel -  90 degree high power pulse
;p22: f3 channel - 180 degree high power pulse
;p8 : f2 channel - 180 degree shaped pulse for inversion (adiabatic)
;p29: gradient pulse 3                                 [300 usec]
;p41: PC9
;p42: REBURP
;p43: EBURP
;d0 : incremented delay (F1)                           [3 usec]
;d1 : relaxation delay; 1-5 * T1
;d11: delay for disk I/O                               [30 msec]
;d16: delay for homospoil/gradient recovery
;d25: 1/(4J(NH)                                     
;d26: 1/(4J(NH)     
;d27: 1/(4J(NH)                            
;cnst1: H(N) excitation frequency (in ppm)
;cnst2: H(N) excitation band width (in ppm)
;cnst26: Call chemical shift (offset, in ppm)          [101 ppm]
;cnst41: Power change for PC9 pulse (dB)
;cnst42: Power change for REBURP pulse (dB)
;cnst43: Power change for EBURP2 pulse (dB)
;inf1: 1/SW(N) = 2 * DW(N)
;in0: 1/(2 * SW(N)) = DW(N)
;nd0: 2
;ns: 2 * n
;ds: >= 16
;td1: number of experiments in F1
;FnMODE: echo-antiecho in F1


;for z-only gradients:
;gpz1: 2%
;gpz2: 21%
;gpz3: -80%
;gpz4: 5%
;gpz5: 30%
;gpz6: 45%
;gpz7: 30.13%

;use gradient files:   
;gpnam1: SMSQ10.32
;gpnam2: SMSQ10.50
;gpnam3: SMSQ10.50
;gpnam4: SMSQ10.32
;gpnam5: SMSQ10.50
;gpnam6: SMSQ10.32
;gpnam7: SMSQ10.50



;Processing

;PHC0(F1): 45.0

