#!/bin/csh

nusExpand.tcl -mode bruker -sampleCount 204 -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

bruk2pipe -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 2200 -dspfvs 20 -grpdly 67.986083984375  \
  -xN              2048  -yN                64  -zN               128  \
  -xT              1024  -yT                32  -zT                64  \
  -xMODE            DQD  -yMODE  Echo-AntiEcho  -zMODE        Complex  \
  -xSW         9090.909  -ySW         1986.492  -zSW        12315.271  \
  -xOBS         700.073  -yOBS          70.946  -zOBS         176.040  \
  -xCAR           4.771  -yCAR         118.074  -zCAR          45.732  \
  -xLAB              HN  -yLAB             15N  -zLAB             13C  \
  -ndim               3  -aq2D         Complex                         \
  -out ./fid/test%03d.fid -verb -ov

xyz2pipe -in ./fid/test%03d.fid -noWr \
| nusExpand.tcl -mask -noexpand -mode pipe -sampleCount 204 -off 0 \
  -in stdin -out ./mask/test%03d.fid -sample ./nuslist

sleep 5
